
IF EXISTS
(
    SELECT *
    FROM sys.views
    WHERE object_id = OBJECT_ID(N'[dbo].V_RC_CLI_CREDIARIO_TENTACLE')
)
    DROP VIEW [dbo].[V_RC_CLI_CREDIARIO_TENTACLE];
GO

CREATE VIEW [dbo].[V_RC_CLI_CREDIARIO_TENTACLE] AS 
SELECT          
	DBO.RC_CLI.CD_EMP, 
	DBO.RC_CLI.CD_CLI, 
	DBO.RC_CLI.RZ_CLI, 
	DBO.RC_CLI.CGC_CPF,
	ISNULL(DBO.RC_CLI_CREDIARIO.VLR_LIM_CRED,0)          AS VLR_LIM_CRED, 
	ISNULL(DBO.RC_CLI_CREDIARIO.VLR_LIM_PARC_CRED,0)     AS VLR_LIM_PARC_CRED, 
	ISNULL(DBO.RC_CLI_CREDIARIO.VLR_LIM_FAT_CRED,0)      AS VLR_LIM_FAT_CRED , 
	ISNULL(DBO.RC_CLI_CREDIARIO.STS_CRED,1)              AS STS_CRED , 
	ISNULL(DBO.RC_CLI_CREDIARIO.VLR_DEB_CRED,0)          AS VLR_DEB_CRED , 
	ISNULL(DBO.RC_CLI_CREDIARIO.VLR_DEB_PARC_CRED,0)    AS VLR_DEB_PARC_CRED, 
	ISNULL(DBO.RC_CLI_CREDIARIO.VLR_DEB_FAT_CRED,0)      AS VLR_DEB_FAT_CRED, 
	ISNULL(DBO.RC_CLI_CREDIARIO.CD_MDL_VD,0)             AS CD_MDL_VD, 
	ISNULL(DBO.RC_MDL_VENDA.QTDE_MAX_PARC_VD,0)          AS QTDE_MAX_PARC_VD, 
	ISNULL(DBO. RC_CLI.NR_CARTAO_ANTIGO,0)               AS CARTAO_ANTIGO, 
	CONVERT (DATE,ISNULL(DBO.RC_CLI_CREDIARIO.DT_ULT_FECHA,GETDATE()))  AS DT_ULT_FECHA , 
	CONVERT (DATE ,ISNULL(DBO.RC_CLI_CREDIARIO.DT_PROX_FECHA,GETDATE())) AS DT_PROX_FECHA, 
	ISNULL(DBO.RC_CLI_FIDELI_CARTAO.NR_CARTAO, '')       AS NR_CARTAO, 
	ISNULL(DBO.RC_CLI_CREDIARIO.CD_MOT_BLOQ_CLI, 0)      AS CD_MOT_BLOQ_CLI,
	GETDATE() AS DT_HR_CARGA
FROM            
	DBO.RC_CLI 
	LEFT OUTER JOIN      DBO.RC_CLI_CREDIARIO  ON              
	DBO.RC_CLI.CD_EMP = DBO.RC_CLI_CREDIARIO.CD_EMP  AND             
	DBO.RC_CLI.CD_CLI = DBO.RC_CLI_CREDIARIO.CD_CLI 
	LEFT JOIN  DBO.RC_MDL_VENDA  ON              
	DBO.RC_CLI_CREDIARIO.CD_EMP = DBO.RC_MDL_VENDA.CD_EMP  AND             
	DBO.RC_CLI_CREDIARIO.CD_MDL_VD = DBO.RC_MDL_VENDA.CD_MDL_VD 
	LEFT OUTER JOIN DBO.RC_CLI_FIDELI_CARTAO  ON              
	DBO.RC_CLI.CD_EMP = DBO.RC_CLI_FIDELI_CARTAO.CD_EMP  AND             
	DBO.RC_CLI.CD_CLI = DBO.RC_CLI_FIDELI_CARTAO.CD_CLI
	WHERE RC_CLI.CD_EMP = 1

GO